/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 11.25)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 *
 *  Uyj #define MAIN aby skompilowa funkcj testujc.
 */

#include <stddef.h>

#define memmove mymemmove

void *memmove(void *dest, void const *src, size_t n)
{
	register char *dp = dest;
	register char const *sp = src;
	if(dp < sp) {
		while(n-- > 0)
			*dp++ = *sp++;
	} else {
		dp += n;
		sp += n;
		while(n-- > 0)
			*--dp = *--sp;
	}

	return dest;
}

#ifdef MAIN

#include <stdio.h>

main()
{
	char a[] = "This is a test.";
	char b[20];

	printf("%s\n", (char *)memmove(b, a, sizeof(a)));
	memmove(&b[9], &b[10], 4);
	printf("%s\n", b);
	memmove(&b[10], &b[9], 4);
	printf("%s\n", b);
	printf("%s\n", a);
	return 0;
}

#endif
